/*****************************************************************************
-  \file : iap2_commands.c
-  \version : $Id: iap2_commands.c, v Exp $
-  \release : $Name:$
-  Contains the source code implementation for forming the messages that has to be sent to the Apple Device
-  \component :
-  \author : Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
-  \copyright (c) 2010 - 2016 Advanced Driver Information Technology.
-  This code is developed by Advanced Driver Information Technology.
-  Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
-  All rights reserved.
-  CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
-           DO NOT CHANGE THE CODE MANUALLY
*****************************************************************************/

#include "iap2_commands.h"
#include "iap2_calculate_parameter_length.h"
#include "iap2_fill_buffer.h"
#include "iap2_utility.h"
#include "iap2_dlt_log.h"

S32 iAP2AccessoryAuthenticationSerialNumber(iAP2Device_t* device, const iAP2AccessoryAuthenticationSerialNumberParameter* theiAP2AccessoryAuthenticationSerialNumberParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_ACCESSORY_AUTHENTICATION_SERIAL_NUMBER;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2AccessoryAuthenticationSerialNumberParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2AccessoryAuthenticationSerialNumberParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2AccessoryAuthenticationSerialNumberParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2AuthenticationCertificate(iAP2Device_t* device, const iAP2AuthenticationCertificateParameter* theiAP2AuthenticationCertificateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_AUTHENTICATION_CERTIFICATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2AuthenticationCertificateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2AuthenticationCertificateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2AuthenticationCertificateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2AuthenticationResponse(iAP2Device_t* device, const iAP2AuthenticationResponseParameter* theiAP2AuthenticationResponseParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_AUTHENTICATION_RESPONSE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2AuthenticationResponseParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2AuthenticationResponseParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2AuthenticationResponseParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2IdentificationInformation(iAP2Device_t* device, const iAP2IdentificationInformationParameter* theiAP2IdentificationInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_IDENTIFICATION_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2IdentificationInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2IdentificationInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2IdentificationInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2CancelIdentification(iAP2Device_t* device, const iAP2CancelIdentificationParameter* theiAP2CancelIdentificationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_CANCEL_IDENTIFICATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2CancelIdentificationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2IdentificationInformationUpdate(iAP2Device_t* device, const iAP2IdentificationInformationUpdateParameter* theiAP2IdentificationInformationUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_IDENTIFICATION_INFORMATION_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2IdentificationInformationUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2IdentificationInformationUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2IdentificationInformationUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestAppLaunch(iAP2Device_t* device, const iAP2RequestAppLaunchParameter* theiAP2RequestAppLaunchParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_APP_LAUNCH;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestAppLaunchParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2RequestAppLaunchParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2RequestAppLaunchParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2OOBBTPairingAccessoryInformation(iAP2Device_t* device, const iAP2OOBBTPairingAccessoryInformationParameter* theiAP2OOBBTPairingAccessoryInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_OOBBT_PAIRING_ACCESSORY_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2OOBBTPairingAccessoryInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2OOBBTPairingAccessoryInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2OOBBTPairingAccessoryInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2OOBBTPairingCompletionInformation(iAP2Device_t* device, const iAP2OOBBTPairingCompletionInformationParameter* theiAP2OOBBTPairingCompletionInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_OOBBT_PAIRING_COMPLETION_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2OOBBTPairingCompletionInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2OOBBTPairingCompletionInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2OOBBTPairingCompletionInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartRouteGuidanceUpdate(iAP2Device_t* device, const iAP2StartRouteGuidanceUpdateParameter* theiAP2StartRouteGuidanceUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_ROUTE_GUIDANCE_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartRouteGuidanceUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartRouteGuidanceUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartRouteGuidanceUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopRouteGuidanceUpdate(iAP2Device_t* device, const iAP2StopRouteGuidanceUpdateParameter* theiAP2StopRouteGuidanceUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_ROUTE_GUIDANCE_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopRouteGuidanceUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StopRouteGuidanceUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StopRouteGuidanceUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartAssistiveTouch(iAP2Device_t* device, const iAP2StartAssistiveTouchParameter* theiAP2StartAssistiveTouchParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_ASSISTIVE_TOUCH;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartAssistiveTouchParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopAssistiveTouch(iAP2Device_t* device, const iAP2StopAssistiveTouchParameter* theiAP2StopAssistiveTouchParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_ASSISTIVE_TOUCH;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopAssistiveTouchParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartAssistiveTouchInformation(iAP2Device_t* device, const iAP2StartAssistiveTouchInformationParameter* theiAP2StartAssistiveTouchInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_ASSISTIVE_TOUCH_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartAssistiveTouchInformationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopAssistiveTouchInformation(iAP2Device_t* device, const iAP2StopAssistiveTouchInformationParameter* theiAP2StopAssistiveTouchInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_ASSISTIVE_TOUCH_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopAssistiveTouchInformationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2BluetoothComponentInformation(iAP2Device_t* device, const iAP2BluetoothComponentInformationParameter* theiAP2BluetoothComponentInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_BLUETOOTH_COMPONENT_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2BluetoothComponentInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2BluetoothComponentInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2BluetoothComponentInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartBluetoothConnectionUpdates(iAP2Device_t* device, const iAP2StartBluetoothConnectionUpdatesParameter* theiAP2StartBluetoothConnectionUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_BLUETOOTH_CONNECTION_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartBluetoothConnectionUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartBluetoothConnectionUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartBluetoothConnectionUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopBluetoothConnectionUpdates(iAP2Device_t* device, const iAP2StopBluetoothConnectionUpdatesParameter* theiAP2StopBluetoothConnectionUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_BLUETOOTH_CONNECTION_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopBluetoothConnectionUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2AcceptCall(iAP2Device_t* device, const iAP2AcceptCallParameter* theiAP2AcceptCallParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_ACCEPT_CALL;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2AcceptCallParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2AcceptCallParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2AcceptCallParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2EndCall(iAP2Device_t* device, const iAP2EndCallParameter* theiAP2EndCallParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_END_CALL;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2EndCallParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2EndCallParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2EndCallParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2HoldStatusUpdate(iAP2Device_t* device, const iAP2HoldStatusUpdateParameter* theiAP2HoldStatusUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_HOLD_STATUS_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2HoldStatusUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2HoldStatusUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2HoldStatusUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2InitiateCall(iAP2Device_t* device, const iAP2InitiateCallParameter* theiAP2InitiateCallParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_INITIATE_CALL;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2InitiateCallParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2InitiateCallParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2InitiateCallParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2MergeCalls(iAP2Device_t* device, const iAP2MergeCallsParameter* theiAP2MergeCallsParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_MERGE_CALLS;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2MergeCallsParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2MuteStatusUpdate(iAP2Device_t* device, const iAP2MuteStatusUpdateParameter* theiAP2MuteStatusUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_MUTE_STATUS_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2MuteStatusUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2MuteStatusUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2MuteStatusUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2SendDTMF(iAP2Device_t* device, const iAP2SendDTMFParameter* theiAP2SendDTMFParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_SEND_DTMF;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2SendDTMFParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2SendDTMFParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2SendDTMFParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartCallStateUpdates(iAP2Device_t* device, const iAP2StartCallStateUpdatesParameter* theiAP2StartCallStateUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_CALL_STATE_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartCallStateUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartCallStateUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartCallStateUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartCommunicationsUpdates(iAP2Device_t* device, const iAP2StartCommunicationsUpdatesParameter* theiAP2StartCommunicationsUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_COMMUNICATIONS_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartCommunicationsUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartCommunicationsUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartCommunicationsUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartListUpdates(iAP2Device_t* device, const iAP2StartListUpdatesParameter* theiAP2StartListUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_LIST_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartListUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartListUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartListUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopCallStateUpdates(iAP2Device_t* device, const iAP2StopCallStateUpdatesParameter* theiAP2StopCallStateUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_CALL_STATE_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopCallStateUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopCommunicationsUpdates(iAP2Device_t* device, const iAP2StopCommunicationsUpdatesParameter* theiAP2StopCommunicationsUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_COMMUNICATIONS_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopCommunicationsUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopListUpdates(iAP2Device_t* device, const iAP2StopListUpdatesParameter* theiAP2StopListUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_LIST_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopListUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2SwapCalls(iAP2Device_t* device, const iAP2SwapCallsParameter* theiAP2SwapCallsParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_SWAP_CALLS;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2SwapCallsParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestDeviceAuthenticationCertificate(iAP2Device_t* device, const iAP2RequestDeviceAuthenticationCertificateParameter* theiAP2RequestDeviceAuthenticationCertificateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_DEVICE_AUTHENTICATION_CERTIFICATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestDeviceAuthenticationCertificateParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestDeviceAuthenticationChallengeResponse(iAP2Device_t* device, const iAP2RequestDeviceAuthenticationChallengeResponseParameter* theiAP2RequestDeviceAuthenticationChallengeResponseParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_DEVICE_AUTHENTICATION_CHALLENGE_RESPONSE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestDeviceAuthenticationChallengeResponseParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2RequestDeviceAuthenticationChallengeResponseParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2RequestDeviceAuthenticationChallengeResponseParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2DeviceAuthenticationFailed(iAP2Device_t* device, const iAP2DeviceAuthenticationFailedParameter* theiAP2DeviceAuthenticationFailedParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_DEVICE_AUTHENTICATION_FAILED;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2DeviceAuthenticationFailedParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2DeviceAuthenticationSucceeded(iAP2Device_t* device, const iAP2DeviceAuthenticationSucceededParameter* theiAP2DeviceAuthenticationSucceededParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_DEVICE_AUTHENTICATION_SUCCEEDED;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2DeviceAuthenticationSucceededParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StatusExternalAccessoryProtocolSession(iAP2Device_t* device, const iAP2StatusExternalAccessoryProtocolSessionParameter* theiAP2StatusExternalAccessoryProtocolSessionParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STATUS_EXTERNAL_ACCESSORY_PROTOCOL_SESSION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StatusExternalAccessoryProtocolSessionParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StatusExternalAccessoryProtocolSessionParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StatusExternalAccessoryProtocolSessionParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartHID(iAP2Device_t* device, const iAP2StartHIDParameter* theiAP2StartHIDParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_HID;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartHIDParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartHIDParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartHIDParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2AccessoryHIDReport(iAP2Device_t* device, const iAP2AccessoryHIDReportParameter* theiAP2AccessoryHIDReportParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_ACCESSORY_HID_REPORT;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2AccessoryHIDReportParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2AccessoryHIDReportParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2AccessoryHIDReportParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopHID(iAP2Device_t* device, const iAP2StopHIDParameter* theiAP2StopHIDParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_HID;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopHIDParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StopHIDParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StopHIDParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2LocationInformation(iAP2Device_t* device, const iAP2LocationInformationParameter* theiAP2LocationInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_LOCATION_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2LocationInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2LocationInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2LocationInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2PlayMediaLibraryCollection(iAP2Device_t* device, const iAP2PlayMediaLibraryCollectionParameter* theiAP2PlayMediaLibraryCollectionParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_COLLECTION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2PlayMediaLibraryCollectionParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2PlayMediaLibraryCollectionParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2PlayMediaLibraryCollectionParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2PlayMediaLibraryCurrentSelection(iAP2Device_t* device, const iAP2PlayMediaLibraryCurrentSelectionParameter* theiAP2PlayMediaLibraryCurrentSelectionParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_CURRENT_SELECTION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2PlayMediaLibraryCurrentSelectionParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2PlayMediaLibraryCurrentSelectionParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2PlayMediaLibraryCurrentSelectionParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2PlayMediaLibraryItems(iAP2Device_t* device, const iAP2PlayMediaLibraryItemsParameter* theiAP2PlayMediaLibraryItems)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_ITEMS;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2PlayMediaLibraryItems;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2PlayMediaLibraryItemsParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2PlayMediaLibraryItemsParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2PlayMediaLibrarySpecial(iAP2Device_t* device, const iAP2PlayMediaLibrarySpecialParameter* theiAP2PlayMediaLibrarySpecialParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_SPECIAL;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2PlayMediaLibrarySpecialParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2PlayMediaLibrarySpecialParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2PlayMediaLibrarySpecialParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartMediaLibraryInformation(iAP2Device_t* device, const iAP2StartMediaLibraryInformationParameter* theiAP2StartMediaLibraryInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_MEDIA_LIBRARY_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartMediaLibraryInformationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartMediaLibraryUpdates(iAP2Device_t* device, const iAP2StartMediaLibraryUpdatesParameter* theiAP2StartMediaLibraryUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_MEDIA_LIBRARY_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartMediaLibraryUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartMediaLibraryUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartMediaLibraryUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopMediaLibraryInformation(iAP2Device_t* device, const iAP2StopMediaLibraryInformationParameter* theiAP2StopMediaLibraryInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_MEDIA_LIBRARY_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopMediaLibraryInformationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopMediaLibraryUpdates(iAP2Device_t* device, const iAP2StopMediaLibraryUpdatesParameter* theiAP2StopMediaLibraryUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_MEDIA_LIBRARY_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopMediaLibraryUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StopMediaLibraryUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StopMediaLibraryUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2SetNowPlayingInformation(iAP2Device_t* device, const iAP2SetNowPlayingInformationParameter* theiAP2SetNowPlayingInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_SET_NOW_PLAYING_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2SetNowPlayingInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2SetNowPlayingInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2SetNowPlayingInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartNowPlayingUpdates(iAP2Device_t* device, const iAP2StartNowPlayingUpdatesParameter* theiAP2StartNowPlayingUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_NOW_PLAYING_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartNowPlayingUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartNowPlayingUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartNowPlayingUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopNowPlayingUpdates(iAP2Device_t* device, const iAP2StopNowPlayingUpdatesParameter* theiAP2StopNowPlayingUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_NOW_PLAYING_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopNowPlayingUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartPowerUpdates(iAP2Device_t* device, const iAP2StartPowerUpdatesParameter* theiAP2StartPowerUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_POWER_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartPowerUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartPowerUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartPowerUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopPowerUpdates(iAP2Device_t* device, const iAP2StopPowerUpdatesParameter* theiAP2StopPowerUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_POWER_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopPowerUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2PowerSourceUpdate(iAP2Device_t* device, const iAP2PowerSourceUpdateParameter* theiAP2PowerSourceUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_POWER_SOURCE_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2PowerSourceUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2PowerSourceUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2PowerSourceUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartTelephonyCallStateInformation(iAP2Device_t* device, const iAP2StartTelephonyCallStateInformationParameter* theiAP2StartTelephonyCallStateInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Message iAP2StartTelephonyCallStateInformation is Deprecated, dont use it. Kindly refer the Apple specification");
    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_TELEPHONY_CALL_STATE_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartTelephonyCallStateInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartTelephonyCallStateInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartTelephonyCallStateInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartTelephonyUpdates(iAP2Device_t* device, const iAP2StartTelephonyUpdatesParameter* theiAP2StartTelephonyUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Message iAP2StartTelephonyUpdates is Deprecated, dont use it. Kindly refer the Apple specification");
    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_TELEPHONY_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartTelephonyUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartTelephonyUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartTelephonyUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopTelephonyCallStateInformation(iAP2Device_t* device, const iAP2StopTelephonyCallStateInformationParameter* theiAP2StopTelephonyCallStateInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Message iAP2StopTelephonyCallStateInformation is Deprecated, dont use it. Kindly refer the Apple specification");
    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_TELEPHONY_CALL_STATE_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopTelephonyCallStateInformationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopTelephonyUpdates(iAP2Device_t* device, const iAP2StopTelephonyUpdatesParameter* theiAP2StopTelephonyUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Message iAP2StopTelephonyUpdates is Deprecated, dont use it. Kindly refer the Apple specification");
    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_TELEPHONY_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopTelephonyUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartUSBDeviceModeAudio(iAP2Device_t* device, const iAP2StartUSBDeviceModeAudioParameter* theiAP2StartUSBDeviceModeAudioParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_USB_DEVICE_MODE_AUDIO;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartUSBDeviceModeAudioParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopUSBDeviceModeAudio(iAP2Device_t* device, const iAP2StopUSBDeviceModeAudioParameter* theiAP2StopUSBDeviceModeAudioParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_USB_DEVICE_MODE_AUDIO;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopUSBDeviceModeAudioParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2VehicleStatusUpdate(iAP2Device_t* device, const iAP2VehicleStatusUpdateParameter* theiAP2VehicleStatusUpdateParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_VEHICLE_STATUS_UPDATE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2VehicleStatusUpdateParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2VehicleStatusUpdateParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2VehicleStatusUpdateParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverActivateCursor(iAP2Device_t* device, const iAP2RequestVoiceOverActivateCursorParameter* theiAP2RequestVoiceOverActivateCursorParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_ACTIVATE_CURSOR;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverActivateCursorParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverConfiguration(iAP2Device_t* device, const iAP2RequestVoiceOverConfigurationParameter* theiAP2RequestVoiceOverConfigurationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_CONFIGURATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverConfigurationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2RequestVoiceOverConfigurationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2RequestVoiceOverConfigurationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverMoveCursor(iAP2Device_t* device, const iAP2RequestVoiceOverMoveCursorParameter* theiAP2RequestVoiceOverMoveCursorParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_MOVE_CURSOR;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverMoveCursorParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2RequestVoiceOverMoveCursorParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2RequestVoiceOverMoveCursorParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverPauseText(iAP2Device_t* device, const iAP2RequestVoiceOverPauseTextParameter* theiAP2RequestVoiceOverPauseTextParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_PAUSE_TEXT;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverPauseTextParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverResumeText(iAP2Device_t* device, const iAP2RequestVoiceOverResumeTextParameter* theiAP2RequestVoiceOverResumeTextParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_RESUME_TEXT;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverResumeTextParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverScrollPage(iAP2Device_t* device, const iAP2RequestVoiceOverScrollPageParameter* theiAP2RequestVoiceOverScrollPageParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_SCROLL_PAGE;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverScrollPageParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2RequestVoiceOverScrollPageParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2RequestVoiceOverScrollPageParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestVoiceOverSpeakText(iAP2Device_t* device, const iAP2RequestVoiceOverSpeakTextParameter* theiAP2RequestVoiceOverScrollPageParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_VOICE_OVER_SPEAK_TEXT;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestVoiceOverScrollPageParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2RequestVoiceOverSpeakTextParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2RequestVoiceOverSpeakTextParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartVoiceOver(iAP2Device_t* device, const iAP2StartVoiceOverParameter* theiAP2StartVoiceOverParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_VOICE_OVER;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartVoiceOverParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartVoiceOverCursorUpdates(iAP2Device_t* device, const iAP2StartVoiceOverCursorUpdatesParameter* theiAP2StartVoiceOverCursorUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_VOICE_OVER_CURSOR_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartVoiceOverCursorUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartVoiceOverCursorUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartVoiceOverCursorUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StartVoiceOverUpdates(iAP2Device_t* device, const iAP2StartVoiceOverUpdatesParameter* theiAP2StartVoiceOverUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_START_VOICE_OVER_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StartVoiceOverUpdatesParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2StartVoiceOverUpdatesParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2StartVoiceOverUpdatesParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopVoiceOver(iAP2Device_t* device, const iAP2StopVoiceOverParameter* theiAP2StopVoiceOverParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_VOICE_OVER;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopVoiceOverParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopVoiceOverCursorUpdates(iAP2Device_t* device, const iAP2StopVoiceOverCursorUpdatesParameter* theiAP2StopVoiceOverCursorUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_VOICE_OVER_CURSOR_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopVoiceOverCursorUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2StopVoiceOverUpdates(iAP2Device_t* device, const iAP2StopVoiceOverUpdatesParameter* theiAP2StopVoiceOverUpdatesParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_STOP_VOICE_OVER_UPDATES;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2StopVoiceOverUpdatesParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2AccessoryWiFiConfigurationInformation(iAP2Device_t* device, const iAP2AccessoryWiFiConfigurationInformationParameter* theiAP2AccessoryWiFiConfigurationInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_ACCESSORY_WI_FI_CONFIGURATION_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2AccessoryWiFiConfigurationInformationParameter;
    iAP2FormCommand.iAP2CalculateParameterLengh = iAP2CalcLengthiAP2AccessoryWiFiConfigurationInformationParameter;
    iAP2FormCommand.iAP2FillMessageBuffer       = iAP2FillMsgBufiAP2AccessoryWiFiConfigurationInformationParameter;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

S32 iAP2RequestWiFiInformation(iAP2Device_t* device, const iAP2RequestWiFiInformationParameter* theiAP2RequestWiFiInformationParameter)
{
    iAP2FormCommand_t iAP2FormCommand;

    iAP2FormCommand.MessageID                   = IAP2_MSG_ID_REQUEST_WI_FI_INFORMATION;
    iAP2FormCommand.iAP2ParameterStructure      = theiAP2RequestWiFiInformationParameter;
    /* As there are no associated parameters for this command, it is not required to calculate the length & fill it */
    iAP2FormCommand.iAP2CalculateParameterLengh = NULL;
    iAP2FormCommand.iAP2FillMessageBuffer       = NULL;

    return iAP2FormandSendCommand(device, iAP2FormCommand);
}

